/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strcasecmp.c,v 1.4 2005/06/02 19:00:37 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_CASECMP -- Compare two strings (case insensitive).
**
**	Parameters:
**		s1 -- first string.
**		s2 -- second string.
**
**	Returns:
**		0: strings are equal
**		<0: 1. string < 2. string
**		>0: 1. string > 2. string
*/

int
sm_str_casecmp(const sm_str_P s1, const sm_str_P s2)
{
	int d, r;
	uint l;

	SM_IS_BUF(s1);
	SM_IS_BUF(s2);
	l = s1->sm_str_len;
	if (l > s2->sm_str_len)
	{
		d = 1;
		l = s2->sm_str_len;
	}
	else if (l == s2->sm_str_len)
		d = 0;
	else
		d = -1;
	r = strncasecmp((const char *) s1->sm_str_base,
			(const char *) s2->sm_str_base, l);
	if (r == 0)
		r = d;
	return r;
}
