/*
 * Copyright (c) 2002, 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strcrt.c,v 1.7 2005/06/02 19:00:37 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/rpool.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_CRT -- Create a buf structure with preallocated memory.
**
**	Parameters:
**		rpool -- The rpool in which to allocate.
**		buf -- Allocated memory to use.
**		len -- Best guess as to how long the buf will be.
**		maxlen -- Maximum length of buf data.
**
**	Returns:
**		New buf object.
**		NULL on error.
*/

sm_str_P
sm_str_crt(sm_rpool_P rpool, uchar *buf, uint len, uint maxlen)
{
	sm_str_P str;

	SM_REQUIRE(maxlen > 0 && len <= maxlen);
	str = sm_rpool_malloc(rpool, sizeof(*str));
	if (str == NULL)
		return NULL;
	str->sm_str_base = buf;
	str->sm_str_size = len;
	str->sm_str_len = len;
	str->sm_str_max = maxlen;
	str->sm_str_rpool = rpool;
	str->sm_magic = SM_STR_MAGIC;
	return str;
}
