/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strscpy0.c,v 1.6 2005/06/09 00:43:40 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/varargs.h"
#include "sm/limits.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_SCPY0 -- Create a str object and copy a char * into it.
**
**	Creates a new str object of size strlen(str) and copies
**	contents of str into it; including trailing '\0', but does not
**	add to the length, i.e., the '\0' is "hidden".
**
**	Parameters:
**		rpool -- The rpool in which to allocate.
**		str -- '\0' terminated str to copy into new object.
**		maxlen -- Maximum length of str data.
**
**	Return:
**		New str object.
**		NULL on error.
*/

sm_str_P
sm_str_scpy0(sm_rpool_P rpool, const char *char_str, uint maxlen)
{
	sm_str_P str;
	uint len;

	SM_REQUIRE(char_str != NULL);

	/* trailing '\0' is copied but not counted */
	len = strlen(char_str) + 1;
	str = sm_str_new(rpool, len, maxlen);
	if (str == NULL)
		return NULL;
	sm_memcpy(str->sm_str_base, char_str, len);

	/* don't count '\0' */
	str->sm_str_len = len - 1;
	return str;
}
