/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: unixaccept.c,v 1.1 2005/08/24 20:55:32 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/fcntl.h"
#include "sm/unixsock.h"

/*
**  UNIX_SERVER_ACCEPT -- Accept an incoming network connection.
**
**	Parameters:
**		listenfd -- fd that we are listening on.
**		addr -- client address that is connecting.
**		addrlen -- length of addr
**	Returns:
**		New socket fd or sm_error
*/

sm_ret_T
unix_server_accept(int listenfd, struct sockaddr *addr, sockaddr_len_T *addrlen)
{
	int connfd;

	SM_REQUIRE(listenfd >= 0);
	SM_REQUIRE(addr != NULL);
	SM_REQUIRE(addrlen != NULL);

	if ((connfd = accept(listenfd, addr, addrlen)) == -1)
	{
		if (errno != EAGAIN)
			return sm_error_perm(SM_EM_NET, errno);
	}
	return connfd;
}
