/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: pmilter_setmaclist.c,v 1.4 2005/06/21 17:46:06 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/ctype.h"
#include "sm/reccom.h"
#include "pmilter.h"
#include "sm/pmfdef.h"
#include "sm/pmfapi.h"
#include "util.h"

#if SM_USE_PMILTER
/*
**  SM_PMFI_SETMACLIST -- Set list of macros to be sent by MTA
**
**	Parameters:
**		pmss_ctx -- task context pmilter/SMTP server
**		where -- which stage?
**		... -- list of macros
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmfi_setmaclist(pmss_ctx_P pmss_ctx, uint where, ...)
{
	sm_ret_T ret;
	uint i, n;
	uint32_t macro;
	va_list ap;

	SM_IS_PMSS_CTX(pmss_ctx);
	ret = SM_SUCCESS;
	if (where >= PM_SMST_MAX)
		return sm_err_perm(EINVAL);
	if (pmss_ctx->pmss_mac_names[where][0] != PMM_END)
		return sm_err_perm(EEXIST);
	va_start(ap, where);
	n = 0;
	while ((macro = va_arg(ap, uint32_t)) != PMM_END)
	{
		if (++n >= PM_MAX_MACROS)
			break;
	}
	va_end(ap);
	if (n >= PM_MAX_MACROS)
		return sm_err_perm(SM_E_OVFLW_NS);

	va_start(ap, where);
	i = 0;
	while ((macro = va_arg(ap, uint32_t)) != PMM_END)
	{
		/* todo: check for double defined macros */
		SM_ASSERT(i < PM_MAX_MACROS);
		pmss_ctx->pmss_mac_names[where][i] = macro;
		++i;
	}
	va_end(ap);

	return ret;
}
#endif /* SM_USE_PMILTER */
