/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-pmilter.c,v 1.1 2005/10/18 06:07:48 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/types.h"
#include "t-pmilter.h"

#if SM_USE_PMILTER

/*
**  SM_GETSTAGE -- translate stage char into array index
**
**	Parameters:
**		arg -- stage (textual description)
**
**	Returns:
**		>=0: stage
**		<0 on error
*/

int
sm_getstage(char arg)
{
	int stage;

	switch (optarg[0])
	{
	  case 'c':
		stage = SM_STAGE_NSEID;
		break;
	  case 'h':
	  case 'e':
		stage = SM_STAGE_HELO;
		break;
	  case 'm':
		stage = SM_STAGE_MAIL;
		break;
	  case 'r':
		stage = SM_STAGE_RCPT;
		break;
	  case 'd':
		stage = SM_STAGE_DATA;
		break;
	  case 'B':
		stage = SM_STAGE_MSG;
		break;
	  case 'b':
		stage = SM_STAGE_DOT;
		break;
	  default:
		stage = -1;
		break;
	}
	return stage;
}

#endif /* SM_USE_PMILTER */
