/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sockmap.h,v 1.4 2005/04/29 21:37:08 ca Exp $
 */

#ifndef SOCKMAP_H
#define SOCKMAP_H 1
#include "sm/generic.h"
#include "sm/str.h"
#include "sm/time.h"
#include "sm/io.h"
#include "sm/socket.h"
#include "sm/unixsock.h"
#include "sm/net.h"

/* arbitrary limit for sanity */
#define SOCKETMAP_MAXL 1000000

typedef struct sm_sockmap_S sm_sockmap_T, *sm_sockmap_P;
struct sm_sockmap_S
{
	sm_file_T	*sockmap_fp;
	const char	*sockmap_name;
	const char	*sockmap_path;
	ipv4_T		 sockmap_ipv4;
	short		 sockmap_port;
	sm_intvl_T	 sockmap_tmout;
};

sm_ret_T sockmap_free(sm_sockmap_P _db);
sm_ret_T sockmap_new(sm_sockmap_P *_pdb);
sm_ret_T sockmap_destroy(sm_sockmap_P *_pdb);
sm_ret_T sockmap_open(sm_sockmap_P _db);
sm_ret_T sockmap_close(sm_sockmap_P _db);
sm_ret_T sockmap_lookup(sm_sockmap_P _db, sm_str_P _key, sm_str_P _data);

#endif /* SOCKMAP_H */
