#!/bin/sh
# $Id: t-mapip-0.sh,v 1.8 2005/06/09 00:43:41 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test lookup of IPv4 addresses.
# Uses t-mapipr-0, t-mm
# ------------------------------------------------------------
#
test -s stop && exit 1
#

BDBIN="bdb1"
BDB="bdb1.db"
ERRS=0

cat > ${BDBIN} <<EOF
1.2.3.4		rhs1234
1.2.3		rhs123
1.2		rhs12
Tag:1.2.3	rhstag123
Default:	default
EOF

# create map
rm -f ${BDB}
./t-mm -t'	' -F ${BDB} < ${BDBIN}
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

for P in ./t-mapipr-0 # ./t-mapip-0
do

# test full lookup
${P} "1.2.3.4" "rhs1234"
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

# test subnet
${P} "1.2.3.5" "rhs123"
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

# test subnet and no match
${P} "1.2.4.5" "rhs12" "1.3.4.5" ""
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

# test tag (full, subnet, no match)
${P} "tag:1.2.3.4" "rhstag123" "tag:1.2.3.5" "rhstag123" "tag:1.2.4.5" ""
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

# test default (just tag) 
${P} "default:4.3.2.1" "default"
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

# no match, not even default
${P} "defau:4.3.2.1" ""
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

done

exit ${ERRS}
