#!/bin/sh
# $Id: t-mt-3.sh,v 1.5 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# mailertable routing tests by contacting SMAR, using BDB, reload
# uses t-smar-1, startsmar.sh, t-mm
# ------------------------------------------------------------
#
test -s stop && exit 1
#

if test X"`uname`" = "XLinux"
then
  echo "$0: SKIPPED (need pthread signal behavior)"
  exit 0
fi

# path to programs
P=..
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=mt-3.out
IP=mt-3.ip
OK=mt-3.ok
TPRG=./t-smar-1
CONF=mt.conf
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

rm -f ${SOCK} ${PIDS}

# prepare mailertable
${CAT} > ${MT} <<EOF
host123.sm9.org	[1.2.3.0]
sm9.org	[1.2.3.2]
.sm9.org	[1.2.3.4]
.org		[1.2.3.6]
.		[1.2.3.9]
EOF
rm -f ${MTMAPDB}
${MM} -t'	' -F ${MTMAPDB} < ${MT}
rm -f ${MT}

# create aliases map for smar
rm -f ${ALIMAP}
${MM} <<EOF
user:	local:
EOF
if test $? -ne 0
then
  echo t-mm failed
  exit 1
fi

${CAT} > ${CONF} <<EOF
smar {
 map mt { type=hash; file=${MTMAPDB}; }
 mailertable { name=mt; }
}
EOF

# start SMAR
${SHELL} ${SD}/startsmar.sh -m -f ${CONF} || exit 1

rm -f ${OUT} ${IP} ${OK}

TEST=1
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<a@host123.sm9.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
${CAT} > ${OK} <<EOF
IP[0]=1.2.3.0 [1020300]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

# change mailertable
${CAT} > ${MT} <<EOF
host123.sm9.org	[9.2.3.0]
sm9.org	[9.2.3.2]
.sm9.org	[9.2.3.4]
.org		[9.2.3.6]
.		[9.2.3.9]
EOF
mv ${MTMAPDB} ${MTMAPDB}-
${MM} -t'	' -F ${MTMAPDB} < ${MT}
rm -f ${MT}

# reload SMAR
for i in `${CAT} ${PIDS}`
do
  kill -USR1 ${i}
done
sleep 1

TEST=2
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<a@host123.sm9.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
${CAT} > ${OK} <<EOF
IP[0]=9.2.3.0 [9020300]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=3
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<a@host124.sm9.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
${CAT} > ${OK} <<EOF
IP[0]=9.2.3.4 [9020304]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=4
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<a@sm9.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
${CAT} > ${OK} <<EOF
IP[0]=9.2.3.2 [9020302]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=5
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<a@smx.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
${CAT} > ${OK} <<EOF
IP[0]=9.2.3.6 [9020306]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=6
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<a@smx.com>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
${CAT} > ${OK} <<EOF
IP[0]=9.2.3.9 [9020309]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

rm -f ${OUT} ${IP} ${OK}

# stop SMAR
for i in `${CAT} ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi

exit ${ERRS}
