/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: pmilter.h,v 1.5 2005/10/18 21:53:45 ca Exp $
 */

#ifndef PMILTER_H
#define PMILTER_H 1
#include "sm/generic.h"

#if SM_USE_PMILTER

sm_ret_T sspm_ehlo(ss_sess_P _ss_sess, sm_ret_T _cur_status);
sm_ret_T sspm_mail(ss_sess_P _ss_sess, sm_ret_T _cur_status, uint _argoffset);
sm_ret_T sspm_rcpt(ss_sess_P _ss_sess, ss_rcpt_P _ss_rcpt, sm_ret_T _cur_status);
sm_ret_T sspm_data(ss_sess_P _ss_sess, sm_ret_T _cur_status, bool *_pskip);
sm_ret_T sspm_msg(ss_sess_P _ss_sess, uchar *_bufp, size_t _bytes2write, bool *_pskip);
sm_ret_T sspm_eob(ss_sess_P _ss_sess, uchar *_bufp, size_t _bytes2write, bool *_pskip);

/*
**  When to try again to reconnect to pmilter?
**  Note: this access "ret" directly! Should there be more error conditions
**  in which a reconnect is tried? Whenever a new error code is introduced
**  this macro must be extended which isn't very maintainable.
*/

#define SSPM_TRY_AGAIN(ss_ctx, ss_sess)					\
	do {								\
		if ((sm_error_temp(SM_EM_SMTPS, EIO) == ret ||		\
		     sm_error_temp(SM_EM_SMTPS, SM_E_WRONG_ID) == ret || \
		     sm_error_temp(SM_EM_SMTPS, SM_E_CONN_CLSD) == ret) && \
		    SSC_IS_MFLAG((ss_ctx), SSC_MFL_PM_421|SSC_MFL_PM_AGAIN) && \
		    !SSC_IS_FLAG((ss_ctx), SSC_FL_PM_TRYCONN) &&	\
		    !SSC_IS_FLAG((ss_ctx), SSC_FL_PM_TRYING))		\
		{							\
			SSC_SET_FLAG((ss_ctx), SSC_FL_PM_TRYCONN);	\
			SSC_CLR_FLAG((ss_ctx), SSC_FL_PM_USE);		\
			sm_log_write(ss_ctx->ssc_lctx,			\
				SS_LCAT_SERVER, SS_LMOD_SERVER,		\
				SM_LOG_DEBUG, 10,			\
				"sev=DBG, ss_sess=%s, status=set_tryconn2milt" \
				, ss_sess->ssse_id);			\
		}							\
	} while (0)


#endif /* SM_USE_PMILTER */

#endif /* PMILTER_H */
